/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_mux3 ( result, sel, data2x, data1x, data0x ) ;

  parameter lpm_type = "lpm_mux" ;
  parameter lpm_size = 3 ;
  parameter lpm_width = 1 ;
  parameter lpm_widths = 2 ;
  parameter polar_sel = "NORMAL" ;
  parameter polar_data2x = "NORMAL" ;
  parameter polar_data1x = "NORMAL" ;
  parameter polar_data0x = "NORMAL" ;
  parameter polar_result = "NORMAL" ;

  input  [lpm_widths-1:0] sel ;
  input  [lpm_width-1:0] data2x ;
  input  [lpm_width-1:0] data1x ;
  input  [lpm_width-1:0] data0x ;
  output [lpm_width-1:0] result ;

  reg  [lpm_widths-1:0] psel ;
  reg  [lpm_width-1:0] pdata2x, pdata1x,pdata0x ;
  reg  [lpm_width-1:0] tmp_result ;
  reg  [lpm_width-1:0] UNKNOWN ;
  integer i;

  initial
    begin
        // check if widths is out of bound
        if((1<< lpm_widths) < lpm_size)
            $display("Error! lpm_widths must be >= 2.\n");
        else if(lpm_widths < 0)
            $display("Error! lpm_widths must be a positive value.\n");
 
		for( i = 0; i < lpm_width; i=i+1)
			UNKNOWN[i] = 1'bx;
	end
 
  always @(sel or data2x or data1x or data0x)
    begin
       psel <= #1 (polar_sel=="INVERT")?~sel:sel ;
       pdata2x <= #1 (polar_data2x=="INVERT")?~data2x:data2x ;
       pdata1x <= #1 (polar_data1x=="INVERT")?~data1x:data1x ;
       pdata0x <= #1 (polar_data0x=="INVERT")?~data0x:data0x ;
    end

  always @(psel or pdata2x or pdata1x or pdata0x)
    begin
       case(psel)
			2'b00: tmp_result = pdata0x ;
			2'b01: tmp_result = pdata1x ;
			2'b10: tmp_result = pdata2x ;
		  default: tmp_result = UNKNOWN ;
	   endcase
	end

	assign result = (polar_result=="INVERT")?~tmp_result:tmp_result ;

endmodule // lpm_mux3
`ifdef SYNTH
`else
`endcelldefine
`endif

